require("./setting/setting.js")
require("./system/webp.js")
require("./system/database.js")

const { generateWAMessageFromContent, proto, prepareWAMessageMedia } = require("@whiskeysockets/baileys")

const util = require("util");
const chalk = require("chalk");
const fs = require("fs");
const path = require("path");
const axios = require("axios");
const qs = require("qs");
const fetch = require("node-fetch");
const { exec, spawn, execSync } = require('child_process');
const os = require('os');
const nou = require('node-os-utils');
const speed = require('performance-now');

module.exports = async (client, m, store) => {
var body = (m.mtype === 'conversation') ? m.message.conversation : (m.mtype == 'imageMessage') ? m.message.imageMessage.caption : (m.mtype == 'videoMessage') ? m.message.videoMessage.caption : (m.mtype == 'extendedTextMessage') ? m.message.extendedTextMessage.text : (m.mtype == 'buttonsResponseMessage') ? m.message.buttonsResponseMessage.selectedButtonId : (m.mtype == 'listResponseMessage') ? m.message.listResponseMessage.singleSelectReply.selectedRowId : (m.mtype == 'templateButtonReplyMessage') ? m.message.templateButtonReplyMessage.selectedId : (m.mtype === 'messageContextInfo') ? (m.message.buttonsResponseMessage?.selectedButtonId || m.message.listResponseMessage?.singleSelectReply.selectedRowId || m.text) : ''
loadDataBase(client, m);
try {
const prefix = ".";
const isCmd = body.startsWith(prefix);
const quoted = m.quoted ? m.quoted : m
const mime = quoted?.msg?.mimetype || quoted?.mimetype || null
const args = m.body.trim().split(/ +/).slice(1)
const qmsg = (m.quoted || m)
const text = q = args.join(" ")

const owners = JSON.parse(fs.readFileSync("./database/owner.json"))
const command = isCmd ? body.slice(prefix.length).trim().split(" ")[0].toLowerCase() : "";
const cmd = prefix + command
const pushname = m.pushName || `${m.sender.split("@")[0]}`
const botNumber = await client.decodeJid(client.user.id)
const isOwner = [botNumber, owner+"@s.whatsapp.net", ...owners].includes(m.sender) ? true : m.isDeveloper ? true : false

try {
  m.isGroup = m.chat.endsWith('g.us');
  if (m.isGroup) {
    let meta = await store.get(m.chat)
    if (!meta) meta = await client.groupMetadata(m.chat)
    m.metadata = meta;
    const p = meta.participants || [];
    m.isAdmin = p.some(i => i.id === m.sender && i.admin);
    m.isBotAdmin = p.some(i => i.id === botNumber && i.admin);
  } else {
    m.metadata = {};
    m.isAdmin = false;
    m.isBotAdmin = false;
  }
} catch {
  m.metadata = {};
  m.isAdmin = false;
  m.isBotAdmin = false;
}

//Conosole.log codes
if (isCmd) {
const from = m.key.remoteJid
const chatType = from.endsWith("@g.us") ? "Group" : "Private"
console.log(
chalk.blue.bold("Messages Detected 🟢"), 
chalk.white.bold("\n▢ Command :"), chalk.green.bold(`${prefix+command}`), 
chalk.white.bold("\n▢ Pengirim :"), chalk.magenta.bold(`${m.sender}`), 
chalk.white.bold("\n▢ Name :"), chalk.red.bold(`${pushname}`), 
chalk.white.bold("\n▢ Chat Type :"), chalk.yellow.bold(`${chatType}`),
chalk.white.bold("\n▢ Tanggal :"), chalk.cyan.bold(`${global.tanggal(Date.now())}\n\n`)
   )
}

//# # # # # # # # # # # # # # # # 

const qtext = {
  key: {
    remoteJid: 'status@broadcast',
    fromMe: false,
    participant: '0@s.whatsapp.net'
  },
  message: {
    newsletterAdminInviteMessage: {
      newsletterJid: '120363279405727331@newsletter',
      caption: `# ${ownername}.`,
      inviteExpiration: 0
    }
  }
}

const qlock = {
  key: {
    participant: '0@s.whatsapp.net',
    ...(m.chat ? { remoteJid: 'status@broadcast' } : {})
  },
  message: {
    locationMessage: {
      name: `# ${ownername}.`,
      jpegThumbnail: ''
    }
  }
}

const qkontak = {
key: {
participant: `0@s.whatsapp.net`,
...(botNumber ? {
remoteJid: `status@broadcast`
} : {})
},
message: {
'contactMessage': {
'displayName': `${global.ownername}`,
'vcard': `BEGIN:VCARD\nVERSION:3.0\nN:XL;ttname,;;;\nFN:ttname\nitem1.TEL;waid=6285641160535:+62 856-4116-0535\nitem1.X-ABLabel:Ponsel\nEND:VCARD`,
sendEphemeral: true
}}
}

//# # # # # # # # # # # # # # # # 
const reply = m.reply = async (teks) => {
return client.sendMessage(m.chat, {
text: teks, 
mentions: [m.sender], 
contextInfo: {
      isForwarded: true,
      forwardedNewsletterMessageInfo: {
        newsletterName: chname,
        newsletterJid: idch,
      },
externalAdReply: {
title: `${global.botname}`, 
body: `© Powered By ${global.ownername}`, 
thumbnailUrl: global.fotoBot, 
sourceUrl: global.url, 
}}}, {quoted: m})
}

const example = (teks) => {
return `\`(!) — Penggunaan:\`\n*${prefix+command} ${teks}*`
}

//# # # # # # # # # # # # # # # # 

switch (command) {
case "menu": case "help": {
  let TampilanMenu =`🪸 hii *@${pushname}*

*— Bot Informations*
▢ • ownername: @${ownername}
▢ • botname: ${botname}
▢ • modebot: ${client.public ? "Public" : "Self"}

\`command\`

*— AI*
▢ • .felo

*— DOWNLOADER*
▢ • .tt
▢ • .ig
▢ • .fb

*— MAKER*
▢ • .sticker
▢ • .wm
▢ • .brat

*— GROUP*
▢ • .group close
▢ • .group open

*— OWNER BOT*
▢ • .ping
▢ • .getcase
▢ • .listcase
▢ • .addcase
▢ • .delcase
▢ • .restart
▢ • .self/public
  `

  // Pesan tanpa tombol
  const message = {
    document: fs.readFileSync('./package.json'), 
    fileName: `🪸 ${botname}`, 
    mimetype: "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    fileLength: 99, 
    caption: TampilanMenu,
    contextInfo: {
      isForwarded: true,
      forwardedNewsletterMessageInfo: {
        newsletterName: chname,
        newsletterJid: idch,
      },
      externalAdReply: {
        thumbnailUrl: global.fotoBot,
        title: `APe Bot`,
        body: `ᴍᴀᴅᴇ ʙʏ © ${ownername}`,
        renderLargerThumbnail: true,
        mediaType: 1
      }
    }
  }

  return await client.sendMessage(m.chat, message, { quoted: m })
}
break
//AI 
case 'felo':
case 'feloai': {
    if (!text) return m.reply(example("apa itu api?"));

    await client.sendMessage(m.chat, {
        react: {
            text: '🤖',
            key: m.key,
        },
    });

    let url = `https://api-ape.my.id/ai/felo?text=${encodeURIComponent(text)}`;

    try {
        let res = await fetch(url);
        let json = await res.json();

        if (json.status && json.result && json.result.answer) {
            let answer = json.result.answer;
            let sources = json.result.source;
            let replyText = answer;

            if (sources && sources.length > 0) {
                replyText += '\n\nSource:';
                sources.forEach((src, index) => {
                    replyText += `\n${index + 1}. ${src.link}`;
                });
            }

            m.reply(replyText.trim());
        } else {
            m.reply(json.message || 'Failed to get a valid response from the Felo API.');
        }
    } catch (e) {
        console.error(e);
        m.reply('An error occurred while contacting the API.');
    }
}
break
//GROUP
case 'grup':
case 'group': {   
    if (!m.isGroup) return m.reply(global.mess.group)
    if (!m.isAdmin) return m.reply(global.mess.admin)

    if (args[0] === 'close') {
        try {
            await client.groupSettingUpdate(m.chat, 'announcement')
            m.reply(`✅ *Sukses Menutup Group 🫡*`)
        } catch (err) {
            m.reply(jsonformat(err))
        }
    } else if (args[0] === 'open') {
        try {
            await client.groupSettingUpdate(m.chat, 'not_announcement')
            m.reply(`✅ *Sukses Membuka Group 🫡*`)
        } catch (err) {
            m.reply(jsonformat(err))
        }
    } else {
        await client.sendMessage(m.chat, {
            image: ppnyauser,
            caption: `☘️ *Silahkan Ketik*\n\n⚙️ Group open\n⚙️ Group close`
        }, { quoted: m })
    }
}
break
//OWNER
case "self": case "public": {
   if (!isOwner) return m.reply(mess.owner)
   let status = true
   if (command == "self") status = false
   client.public = status
   fs.writeFileSync("./database/mode.json", JSON.stringify({ public: status }, null, 2))
   return m.reply(`Berhasil mengganti ke mode *${command}*`)
}
break

case "restart": {
if (!isOwner) return m.reply(mess.owner)
function restartServer() {
const newProcess = spawn(process.argv[0], process.argv.slice(1), {
    detached: true,
    stdio: "inherit",
  });
  process.exit(0);
}
await m.reply("wait")
await setTimeout(() => {
restartServer();
}, 4500)
}
break

case "getcase": { 
if (!isOwner) return reply(mess.owner)
if (!text) return m.reply(example("menu"))
const getcase = (cases) => {
return "case "+`\"${cases}\"`+fs.readFileSync('./ap.js').toString().split('case \"'+cases+'\"')[1].split("break")[0]+"break"
}
try {
m.reply(`*Case yang mungkin kamu cari:*
${getcase(q)}`)
} catch (e) {
return m.reply(`Case *${text}* tidak ditemukan`)
}
}
break

case 'delcase': {
if (!isOwner) return m.reply(mess.owner)
if (!q) return reply(example("nama case nya\n*.listcase* untuk melihat all case"))
hapusCase('./ap.js', q) //sesuaikan nama file nya
reply(`Berhasil menghapus case *${q}*`)
}
break

case 'addcase': {
if (!isOwner) return m.reply(mess.owner)
const namaFile = 'ap.js'; //sesuaikan nama file nya
const caseBaru = `${text}`;
fs.readFile(namaFile, 'utf8', (err, data) => {
    if (err) {
        console.error('Terjadi kesalahan saat membaca file:', err);
        return;
    }
    const posisiAwalGimage = data.indexOf("case 'addcase':");

    if (posisiAwalGimage !== -1) {
        const kodeBaruLengkap = data.slice(0, posisiAwalGimage) + '\n' + caseBaru + '\n' + data.slice(posisiAwalGimage);
        fs.writeFile(namaFile, kodeBaruLengkap, 'utf8', (err) => {
            if (err) {
                reply('Terjadi kesalahan saat menulis file:', err);
            } else {
                reply('Case baru berhasil ditambahkan.');
            }
        });
    } else {
        reply('Tidak dapat menambahkan case dalam file.');
    }
});
}
break

case 'listcase': {
    if (!isOwner) return m.reply(mess.owner);
    reply(await listCase());
}
break;

case 'del':
case 'd':
case 'delete':{
client.sendMessage(m.chat,
{
delete: {
remoteJid: m.chat,
fromMe: true,
id: m.quoted.id,
participant: m.quoted.sender
}
})
}
break

// # # # # # Info Menu # # # # #
case "ping": {
let timestamp = speed();
let latensi = speed() - timestamp;
let tio = await nou.os.oos();
var tot = await nou.drive.info();
let respon = `*—Informasi Server Vps 🖥️*
- *Platform :* ${nou.os.type()}
- *Total Ram :* ${formatp(os.totalmem())}
- *Total Disk :* ${tot.totalGb} GB
- *Total Cpu :* ${os.cpus().length} Core
- *Runtime Vps :* ${runtime(os.uptime())}

*—Informasi Server Panel 🌐*
- *Respon Speed :* ${latensi.toFixed(4)} detik
- *Runtime Bot :* ${runtime(process.uptime())}`
await m.reply(respon)
}
break
case "owner": {
await client.sendContact(m.chat, [global.owner], null)
await reply(`@${m.sender.split("@")[0]} developer bot!`)
}
break
//MAKER
case "sticker": case "stiker": case "sgif": case "s": {
if (!/image|video/.test(mime)) return m.reply("Kirim foto nya!")
if (/video/.test(mime)) {
if ((qmsg).seconds > 15) return m.reply("Durasi vidio maksimal 15 detik!")
if (!m.isGroup) return m.reply(global.mess.group) // 🔒 Hanya untuk grup
}
var media = await client.downloadAndSaveMediaMessage(qmsg)
await client.sendImageAsSticker(m.chat, media, m, {packname: `Whatsapp Bot ${ownername}`})
await fs.unlinkSync(media)
}
break
case 'wm': {

  if (!quoted) return m.reply(`Balas gambar/video dengan caption *${prefix + command} nama_wm*`)
  if (!text) return m.reply(example("nama watermark"))
if (!m.isGroup) return m.reply(global.mess.group) // 🔒 Hanya untuk grup
  try {
    if (/image/.test(mime)) {
      let media = await client.downloadAndSaveMediaMessage(quoted)
      await client.sendImageAsSticker(m.chat, media, m, { packname: text })
      await fs.unlinkSync(media)
    } else if (/video/.test(mime)) {
      if ((quoted.msg || quoted).seconds > 15) return m.reply("⚠️ Durasi video maksimal 15 detik!")
      let media = await client.downloadAndSaveMediaMessage(quoted)
      await client.sendImageAsSticker(m.chat, media, m, { packname: text })
      await fs.unlinkSync(media)
    } else {
      m.reply("⚠️ Format tidak didukung, kirim gambar atau video saja!")
    }
  } catch (e) {
    console.error(e)
    m.reply(mess.error)
  }
}
break
case 'brat': {
    if (!text) return m.reply(example("hai kamu"));
if (!m.isGroup) return m.reply(global.mess.group) // 🔒 Hanya untuk grup

    await client.sendMessage(m.chat, {
        react: {
            text: '⏱️',
            key: m.key,
        }
    });

    try {
        let url = `https://api.siputzx.my.id/api/m/brat?text=${encodeURIComponent(text)}&isVideo=false&delay=500`;
        await client.sendMessage(m.chat, {
            sticker: { url },
        }, { quoted: m });
    } catch (error) {
        console.error(error);
        m.reply('Terjadi kesalahan saat membuat stiker.');
    }
}
break
//TOOLS
case "remini": case "hd": {
  const q = m.quoted ? m.quoted : m
  const mime = q.mimetype || q.msg?.mimetype || ''
  if (!/image\/(jpe?g|png)/i.test(mime)) {
    await client.sendMessage(m.chat, { react: { text: '❗', key: m.key } })
    return m.reply(`Kirim atau *balas gambar* dengan perintah:\n*${prefix + command}*`)
  }
if (!m.isGroup) return m.reply(global.mess.group) // 🔒 Hanya untuk grup
  try {
    await client.sendMessage(m.chat, { react: { text: '⏳', key: m.key } })

    const media = await q.download()
    const ext = mime.split('/')[1]
    const filename = `upscaled_${Date.now()}.${ext}`

    const form = new (require('form-data'))()
    form.append('image', media, { filename, contentType: mime })
    form.append('scale', '2')

    const headers = {
      ...form.getHeaders(),
      'accept': 'application/json',
      'x-client-version': 'web',
      'x-locale': 'en'
    }

    const res = await fetch('https://api2.pixelcut.app/image/upscale/v1', {
      method: 'POST',
      headers,
      body: form
    })

    const json = await res.json()
    if (!json?.result_url || !json.result_url.startsWith('http')) {
      throw new Error('Gagal mendapatkan URL hasil dari Pixelcut.')
    }

    const resultBuffer = await (await fetch(json.result_url)).buffer()

    await client.sendMessage(m.chat, {
      image: resultBuffer,
      caption: `
✨ Gambar berhasil ditingkatkan hingga 2x resolusi!

📈 Kualitas lebih tajam & detail lebih jelas.
🔧 _Gunakan fitur ini untuk memperjelas gambar blur._
`.trim()
    }, { quoted: m })

    await client.sendMessage(m.chat, { react: { text: '✅', key: m.key } })
  } catch (err) {
    await client.sendMessage(m.chat, { react: { text: '❌', key: m.key } })
    m.reply(`❌ Upscaling gagal:\n${err.message || err}`)
  }
}
break
//DOWNLOADER
case "tt":
case "ttdl":
case "tiktok": {
  if (!text) return m.reply('Mana link TikTok-nya?');
  if (!text.includes('tiktok.com')) return m.reply('Link-nya tidak valid!');
if (!m.isGroup) return m.reply(global.mess.group) // 🔒 Hanya untuk grup

  await client.sendMessage(m.chat, {
    react: { text: '⏳', key: m.key }
  });

  try {
    async function tiktok2(query) {
      const encodedParams = new URLSearchParams();
      encodedParams.set('url', query);
      encodedParams.set('hd', '1');

      const response = await axios({
        method: 'POST',
        url: 'https://tikwm.com/api/',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
          'Cookie': 'current_language=en',
          'User-Agent': 'Mozilla/5.0 (Linux; Android 10) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Mobile Safari/537.36'
        },
        data: encodedParams
      });

      const videos = response.data.data;
      if (!videos) throw new Error('Video tidak ditemukan.');

      return {
        title: videos.title || 'Video TikTok',
        no_watermark: videos.play,
        music: videos.music
      };
    }

    // Ambil data
    const result = await tiktok2(text);

    // Kirim video
    await client.sendMessage(m.sender, {
      video: { url: result.no_watermark },
      caption: `🎬 ${result.title}`
    });

    // Kirim audio
    await client.sendMessage(m.sender, {
      audio: { url: result.music },
      mimetype: 'audio/mp4',
      fileName: 'tiktok-audio.mp3'
    });

    m.reply('✅ Sudah dikirim ke private message yaa!');
  } catch (e) {
    console.error(e);
    m.reply('❌ Gagal mengambil data. Pastikan link TikTok valid.');
  }
}
break
case "ig":
case "igdl":
case "instagram": {
  if (!text) return m.reply(`*Contoh:* ig. https://www.instagram.com/p/xxxxxxx`);
if (!m.isGroup) return m.reply(global.mess.group) // 🔒 Hanya untuk grup

  async function JHINSave(instaUrl) {
    const axios = (await import('axios')).default;
    const { load } = await import('cheerio');
    const qs = (await import('qs')).default;

    const headers = { 'Content-Type': 'application/x-www-form-urlencoded' };
    const data = qs.stringify({ url: instaUrl, lang: 'en' });

    try {
      const res = await axios.post('https://api.instasave.website/media', data, { headers });
      const html = (res.data.match(/innerHTML\s*=\s*"(.+?)";/s)?.[1] || '').replace(/\\"/g, '"');

      const $ = load(html);
      const result = [];
      $('.download-items').each((_, el) => {
        const url = $(el).find('a[title="Download"]').attr('href');
        const type = $(el).find('.format-icon i').attr('class')?.includes('ivideo') ? 'video' : 'image';
        if (url) result.push({ type, url });
      });

      if (!result.length) throw new Error('Media not found');
      return result;
    } catch (e) {
      return { error: e.response?.data || e.message };
    }
  }

  try {
    // Reaksi loading
    await client.sendMessage(m.chat, { react: { text: '⏱️', key: m.key } });

    const result = await JHINSave(text);

    if (!result || result.error) {
      throw new Error(typeof result?.error === 'string' ? result.error : 'Gagal mengambil media.');
    }

    if (!Array.isArray(result) || !result.length) {
      throw new Error('Media tidak ditemukan atau link tidak valid.');
    }

    const caption = `🎁 *Instagram Selesai*\n\nCek DM ya! (${result.length} file)`;
    await client.sendMessage(m.chat, { text: caption }, { quoted: m });

    // Kirim semua media ke DM user
    for (let i = 0; i < result.length; i++) {
      const item = result[i];
      const cap = `Berikut hasil download Instagram-mu. (${i + 1}/${result.length})`;
      try {
        if (item.type === 'video') {
          await client.sendMessage(m.sender, {
            video: { url: item.url },
            caption: cap
          });
        } else {
          await client.sendMessage(m.sender, {
            image: { url: item.url },
            caption: cap
          });
        }
      } catch {
        // fallback: kirim ke chat kalau DM gagal
        if (item.type === 'video') {
          await client.sendMessage(m.chat, {
            video: { url: item.url },
            caption: cap
          }, { quoted: m });
        } else {
          await client.sendMessage(m.chat, {
            image: { url: item.url },
            caption: cap
          }, { quoted: m });
        }
      }
    }

    await client.sendMessage(m.chat, { react: { text: '✅', key: m.key } });
  } catch (error) {
    console.error("Error IG:", error);
    await client.sendMessage(m.chat, { text: `❌ Terjadi kesalahan: ${error.message}` }, { quoted: m });
    await client.sendMessage(m.chat, { react: { text: '❌', key: m.key } });
  }
}
break
case "fbdl":
case "facebook":
case "fb": {
 if (!m.isGroup) return m.reply(global.mess.group) // 🔒 Hanya untuk grup
  if (!text) return m.reply('Berikan Link Video Facebook\n\n*Contoh:* .fb https://www.facebook.com/share/r/1CPBzcrwAb/');

  // kasih reaksi loading biar keren
  await client.sendMessage(m.chat, {
    react: { text: '⏳', key: m.key }
  });

  const fbvdl = async (fbUrl) => {
    const fixUrl = (url) => url?.replace(/\\/g,"") || null;
    
    if (typeof(fbUrl) !== "string") throw Error(`Mana url nya`);
    const headers = {
      "accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7",
      "sec-fetch-site": "none",
      "sec-fetch-user": "?1",
      "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0",
    };
    
    const response = await fetch(fbUrl, { headers });
    if (!response.ok) throw Error(`${response.status} ${response.statusText} ${response.url}\n${await response.text()||null}`);
    const html = await response.text();
    
    const m_sd = html.match(/"browser_native_sd_url":"(.+?)",/)?.[1];
    const m_hd = html.match(/"browser_native_hd_url":"(.+?)",/)?.[1];
    const m_a  = html.match(/"mime_type":"audio\\\/mp4","codecs":"mp4a\.40\.5","base_url":"(.+?)",/)?.[1];
    
    return {
      sd: fixUrl(m_sd),
      hd: fixUrl(m_hd),
      audio: fixUrl(m_a)
    };
  };

  try {
    const { hd, audio } = await fbvdl(text);

    if (!hd && !audio) throw '❌ Gagal mendapatkan link download.';

    // kirim video ke private
    if (hd) {
      await client.sendMessage(m.sender, {
        video: { url: hd },
        caption: "🎬 Facebook Video"
      });
    }

    // kirim audio ke private
    if (audio) {
      await client.sendMessage(m.sender, {
        audio: { url: audio },
        mimetype: 'audio/mp4',
        fileName: 'facebook-audio.mp3'
      });
    }

    // info ke grup/chat umum
    m.reply('✅ Sudah dikirim ke private message yaa!');
  } catch (e) {
    console.error(e);
    m.reply('❌ Gagal mengambil data. Pastikan link Facebook valid.');
  }
}
break
//STORE
default:
if (m.text.toLowerCase().startsWith("eval")) {
    if (!isOwner) return;
    try {
        const result = await eval(`(async () => { ${text} })()`);
        const output = typeof result !== "string" ? util.inspect(result) : result;
        return client.sendMessage(m.chat, { text: util.format(output) }, { quoted: m });
    } catch (err) {
        return client.sendMessage(m.chat, { text: util.format(err) }, { quoted: m });
    }
}

if (m.text.toLowerCase().startsWith("report")) {
    if (!text) return m.reply(`${prefix + command} apa yang eror?`);
    let laporan = `*Report Message Received 🟢* 
    
- Pengirim : @${m.sender.split("@")[0]}
- *Pesan : ${text}*

*⚠️ Mohon segera diperbaiki!*`;
    try {
        await client.sendMessage(global.owner + "@s.whatsapp.net", { 
            text: laporan, 
            mentions: [m.sender] 
        });
        return m.reply("Laporan berhasil di kirim, mohon tunggu!");
    } catch (err) {
        return m.reply("Gagal mengirim laporan, coba lagi nanti.");
    }
}

if (m.text.toLowerCase().startsWith("x")) {
    if (!isOwner) return;

    try {
        let result = await eval(text);
        if (typeof result !== "string") result = util.inspect(result);
        return client.sendMessage(m.chat, { text: util.format(result) }, { quoted: m });
    } catch (err) {
        return client.sendMessage(m.chat, { text: util.format(err) }, { quoted: m });
    }
}

if (m.text.startsWith('$')) {
    if (!isOwner) return;
    
    exec(m.text.slice(2), (err, stdout) => {
        if (err) {
            return client.sendMessage(m.chat, { text: err.toString() }, { quoted: m });
        }
        if (stdout) {
            return client.sendMessage(m.chat, { text: util.format(stdout) }, { quoted: m });
        }
    });
}

}

} catch (err) {
console.log(err)
await client.sendMessage(global.owner+"@s.whatsapp.net", {text: err.toString()}, {quoted: m ? m : null })
}}

//# # # # # # # # # # # # # # # # 

process.on("uncaughtException", (err) => {
console.error("Caught exception:", err);
});

let file = require.resolve(__filename);
fs.watchFile(file, () => {
    fs.unwatchFile(file);
    console.log(chalk.blue(">> Update File:"), chalk.black.bgWhite(__filename));
    delete require.cache[file];
    require(file);
});