process.on("uncaughtException", (err) => {
  console.error("Caught exception:", err);
});

require("./setting/setting.js");
require("./system/webp.js");
require("./library/function.js");
require("./system/database.js");

const {
  default: makeWASocket,
  makeCacheableSignalKeyStore,
  useMultiFileAuthState,
  DisconnectReason,
  fetchLatestBaileysVersion,
  generateForwardMessageContent,
  prepareWAMessageMedia,
  generateWAMessageFromContent,
  generateMessageID,
  downloadContentFromMessage,
  makeInMemoryStore,
  getContentType,
  jidDecode,
  MessageRetryMap,
  proto,
  delay,
  Browsers,
  areJidsSameUser, // <— DITAMBAH
} = require("@whiskeysockets/baileys");

const { say } = require("cfonts");
const path = require("path");
const pino = require("pino");
const { Boom } = require("@hapi/boom");
const fs = require("fs");
const PhoneNumber = require("awesome-phonenumber");
const readline = require("readline");
const chalk = require("chalk");
const qrcode = require("qrcode-terminal");
const FileType = require("file-type");
const os = require("os");
const nou = require("node-os-utils");
// Pastikan direktori database/Sampah ada
const tempDir = path.join(__dirname, "database", "Sampah");
if (!fs.existsSync(tempDir)) {
  console.log(`[INFO] Creating temporary directory: ${tempDir}`);
  fs.mkdirSync(tempDir, { recursive: true });
}
const speed = require("performance-now");
let timestamp = speed();
let latensi = speed() - timestamp;
let tio = nou.os.oos();
var tot = nou.drive.info();
const ConfigBaileys = require("./system/config.js");

// default public
let mode = { public: true };
if (fs.existsSync("./database/mode.json")) {
  mode = JSON.parse(fs.readFileSync("./database/mode.json"));
}

const store = makeInMemoryStore({
  logger: pino().child({ level: "silent", stream: "store" }),
});

const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout,
});

async function InputNumber(promptText) {
  return new Promise((resolve) => {
    rl.question(promptText, (answer) => {
      resolve(answer); // jangan close disini
    });
  });
}

setInterval(async () => {
  const sessi = await fs
    .readdirSync("./session")
    .filter((e) => e !== "creds.json");
  const satuJam = 60 * 60 * 1000;
  const sekarang = Date.now();
  for (let i of sessi) {
    const sessionPath = `./session/${i}`;
    const stats = fs.statSync(sessionPath);
    const modifiedTime = stats.mtimeMs;
    if (sekarang - modifiedTime > satuJam) {
      fs.unlinkSync(sessionPath);
    }
  }
}, 60000 * 30);

const groupMetadataCache = new Map();

async function startBot() {
  const { state, saveCreds } = await useMultiFileAuthState("session");
  const pairingCode = true;

  const client = makeWASocket({
    browser: Browsers.ubuntu("Firefox"),
    generateHighQualityLinkPreview: true,
    printQRInTerminal: !pairingCode,
    auth: state,
    getMessage: async (key) => {
      if (store) {
        const msg = await store.loadMessage(key.remoteJid, key.id);
        return msg.message || undefined;
      }
    },
    logger: pino({ level: "silent" }),
    cachedGroupMetadata: async (jid) => {
      if (groupMetadataCache.has(jid)) {
        return groupMetadataCache.get(jid);
      }
      try {
        const metadata = await client.groupMetadata(jid);
        groupMetadataCache.set(jid, metadata);
        return metadata;
      } catch (err) {
        console.error(`Failed to fetch metadata for group ${jid}:`, err);
        // jangan return null, kasih objek kosong
        return { id: jid, subject: "Unknown Group", participants: [] };
      }
    },
  });

  if (pairingCode && !client.authState.creds.registered) {
    let phoneNumber = await InputNumber(
      chalk.green.bold("Enter Your Number (628) :\n")
    );
    phoneNumber = phoneNumber.replace(/[^0-9]/g, "");
    setTimeout(async () => {
      const code = await client.requestPairingCode(
        phoneNumber,
        `${global.pairingCode}`
      );
      await console.log(
        `${chalk.yellow.bold("Your Code")} : ${chalk.cyan.bold(code)}`
      );
    }, 4000);
  }

  store?.bind(client.ev);

  client.ev.on("creds.update", saveCreds);

client.ev.on(
  "connection.update",
  async ({ connection, lastDisconnect, qr }) => {
    if (!connection) return;

    // Saat sedang connecting
    if (connection === "connecting") {
      if (qr && !pairingCode) {
        console.log("Scan QR ini di WhatsApp:");
        qrcode.generate(qr, { small: true });
      }
    }

    // Saat koneksi tertutup
    if (connection === "close") {
      const reason = new Boom(lastDisconnect?.error)?.output?.statusCode;
      console.error(lastDisconnect?.error);

      switch (reason) {
        case DisconnectReason.badSession:
          console.log("Bad Session File, Please Delete Session and Scan Again");
          process.exit();
          break;

        case DisconnectReason.connectionClosed:
          console.log("[SYSTEM] Connection closed, reconnecting...");
          await startBot();
          break;

        case DisconnectReason.connectionLost:
          console.log("[SYSTEM] Connection lost, trying to reconnect...");
          await startBot();
          break;

        case DisconnectReason.connectionReplaced:
          console.log("Connection Replaced, Another New Session Opened. Please Close Current Session First.");
          await client.logout();
          break;

        case DisconnectReason.restartRequired:
          console.log("Restart Required...");
          await startBot();
          break;

        case DisconnectReason.loggedOut:
          console.log("Device Logged Out, Please Scan Again And Run.");
          await client.logout();
          break;

        case DisconnectReason.timedOut:
          console.log("Connection TimedOut, Reconnecting...");
          await startBot();
          break;

        default:
          await startBot();
          break;
      }

    // Saat koneksi terbuka
    } else if (connection === "open") {
      try {
        await loadConnect(client);
        console.clear();

        // Kirim laporan connect ke owner (tanpa menutup proses)
        const toArray = v => Array.isArray(v) ? v : [v];
        const normalizeJid = num => String(num).replace(/\D/g, "") + "@s.whatsapp.net";
        const owners = toArray(global.owner || process.env.OWNER || "6282242995870");
        const jids = owners.slice(0, 1).map(normalizeJid);

        const msg =
          `${global.botname || "Bot"} berhasil terhubung ke WhatsApp ✅\n` +
          `Waktu: ${new Date().toLocaleString()}`;

        for (const jid of jids) {
          await client.sendMessage(jid, { text: msg });
        }

        console.log(`[OK] ${global.botname || "Bot"} connected. Laporan dikirim ke owner.`);
        // Jangan pakai process.exit(...) supaya tidak close
      } catch (err) {
        console.error("Gagal kirim laporan/connect:", err);
        // Jangan exit di sini juga
      }
    }
  }
);
      
  client.ev.on("messages.upsert", async (m) => {
    try {
      const msg = m.messages[0];
      if (!msg.message) return;
      m = await ConfigBaileys(client, msg);
      await loadDataBase(client, msg);
      const botNumber = await client.decodeJid(client.user.id);
      // AUTO READ STATUS
      if (msg.key.remoteJid === "status@broadcast" && global.db.settings.readsw) {
        await client.readMessages([msg.key]);
      }
      // AUTO READ ALL CHATS
      if (global.db.settings.autoread) {
        await client.readMessages([msg.key]);
      }
      // AUTO TYPING
      if (global.db.settings.autotyping && !msg.key.fromMe) {
        await client.sendPresenceUpdate("composing", msg.key.remoteJid);
      }
      // PUBLIC MODE CHECK
      if (!client.public && m.sender !== botNumber) return;
      if (m.isBaileys) return;
      require("./ap.js")(client, m, groupMetadataCache);
    } catch (err) {
      console.error("Error on message:", err);
    }
  });

  client.public = mode.public;

  client.decodeJid = (jid) => {
    if (!jid) return jid;
    if (/:\d+@/gi.test(jid)) {
      let decode = jidDecode(jid) || {};
      return (decode.user && decode.server && decode.user + "@" + decode.server) || jid;
    } else return jid;
  };

  client.downloadAndSaveMediaMessage = async (message, filename, attachExtension = true) => {
    let quoted = message.msg ? message.msg : message;
    let mime = (message.msg || message).mimetype || "";
    let messageType = message.mtype
      ? message.mtype.replace(/Message/gi, "")
      : mime.split("/")[0];
    const Randoms = Date.now();
    const fil = Randoms;
    const stream = await downloadContentFromMessage(quoted, messageType);
    let buffer = Buffer.from([]);
    for await (const chunk of stream) {
      buffer = Buffer.concat([buffer, chunk]);
    }

    let type = await FileType.fromBuffer(buffer);
    let trueFileName = attachExtension
      ? "./database/Sampah/" + fil + "." + type.ext
      : filename;
    await fs.writeFileSync(trueFileName, buffer);

    return trueFileName;
  };

  client.sendImageAsSticker = async (jid, pathInput, quoted, options = {}) => {
    let buff = Buffer.isBuffer(pathInput)
      ? pathInput
      : /^data:.*?\/.*?;base64,/i.test(pathInput)
      ? Buffer.from(pathInput.split`, `[1], "base64")
      : /^https?:\/\//.test(pathInput)
      ? await (await getBuffer(pathInput))
      : fs.existsSync(pathInput)
      ? fs.readFileSync(pathInput)
      : Buffer.alloc(0);

    let buffer;
    if (options && (options.packname || options.author)) {
      buffer = await writeExifImg(buff, options);
    } else {
      buffer = await imageToWebp(buff);
    }

    await client.sendMessage(
      jid,
      { sticker: { url: buffer }, ...options },
      { quoted }
    );
    return buffer;
  };

  client.sendVideoAsSticker = async (jid, pathInput, quoted, options = {}) => {
    let buff = Buffer.isBuffer(pathInput)
      ? pathInput
      : /^data:.*?\/.*?;base64,/i.test(pathInput)
      ? Buffer.from(pathInput.split`, `[1], "base64")
      : /^https?:\/\//.test(pathInput)
      ? await (await getBuffer(pathInput))
      : fs.existsSync(pathInput)
      ? fs.readFileSync(pathInput)
      : Buffer.alloc(0);

    let buffer;
    if (options && (options.packname || options.author)) {
      buffer = await writeExifVid(buff, options);
    } else {
      buffer = await videoToWebp(buff);
    }

    await client.sendMessage(
      jid,
      { sticker: { url: buffer }, ...options },
      { quoted }
    );
    return buffer;
  };

  client.sendContact = async (jid, kon, quoted = "", opts = {}) => {
    let list = [];
    for (let i of kon) {
      list.push({
        displayName: `${ownername}`,
        vcard: `BEGIN:VCARD\nVERSION:3.0\nN:${ownername}\nFN:${ownername}\nitem1.TEL;waid=${i}:${i}\nitem1.X-ABLabel:Ponsel\nitem2.ADR:;;Indonesia;;;;\nitem2.X-ABLabel:Region\nEND:VCARD`,
      });
    }
    client.sendMessage(
      jid,
      { contacts: { displayName: `${list.length} Kontak`, contacts: list }, ...opts },
      { quoted }
    );
  };

  client.getName = async (jid = "", withoutContact = false) => {
    try {
      jid = client.decodeJid(jid || "");

      withoutContact = client.withoutContact || withoutContact;

      let v;

      // Jika jid adalah grup
      if (jid.endsWith("@g.us")) {
        return new Promise(async (resolve) => {
          try {
            v = client.chats[jid] || {};
            if (!(v.name || v.subject)) {
              v = await client.groupMetadata(jid).catch(() => ({}));
            }

            resolve(
              v.name ||
                v.subject ||
                (typeof jid === "string"
                  ? PhoneNumber(
                      "+" + jid.replace("@s.whatsapp.net", "")
                    ).getNumber("international")
                  : "Unknown Group")
            );
          } catch (err) {
            resolve("Unknown Group");
          }
        });
      } else {
        v =
          jid === "0@s.whatsapp.net"
            ? { jid, vname: "WhatsApp" }
            : areJidsSameUser(jid, client.user.id)
            ? client.user
            : client.chats[jid] || {};
      }

      const safeJid = typeof jid === "string" ? jid : "";
      const result =
        (withoutContact ? "" : v.name) ||
        v.subject ||
        v.vname ||
        v.notify ||
        v.verifiedName ||
        (safeJid &&
        safeJid !== "undefined" &&
        safeJid !== ""
          ? PhoneNumber(
              "+" + safeJid.replace("@s.whatsapp.net", "")
            )
              .getNumber("international")
              .replace(new RegExp("[()+-/ +/]", "gi"), "")
          : "Unknown Contact");
      return result;
    } catch (error) {
      return "Error occurred";
    }
  };
}

startBot();