import express from 'express';
import axios from 'axios';
const router = express.Router();

router.use(express.json());

const handleAi4Chat = async (req, res, text) => {
  if (!text) return res.status(400).json({ status: false, error: 'Text is required' });

  const AP = 'AP';
  const apiUrl = `https://yw85opafq6.execute-api.us-east-1.amazonaws.com/default/boss_mode_15aug?text=nama kamu adalah ${AP}, kamu berbahasa indonesia&text=${encodeURIComponent(text)}&user_id=M08wTiyb56`;

  try {
    const response = await axios.get(apiUrl);
    const result = response.data?.comment || response.data || 'Tidak ada respons dari AI.';
    res.json({ status: true, result });
  } catch (error) {
    res.status(500).json({ status: false, error: error.message });
  }
};

/**
 * @swagger
 * /ai/Ai4Chat:
 *   get:
 *     tags:
 *       - AI
 *     summary: AI4Chat (GET) - Tanya AI Ramah
 *     parameters:
 *       - in: query
 *         name: text
 *         required: true
 *         schema:
 *           type: string
 *     responses:
 *       200:
 *         description: Respons berhasil
 */
router.get('/', async (req, res) => {
  await handleAi4Chat(req, res, req.query.text);
});

/**
 * @swagger
 * /ai/Ai4Chat:
 *   post:
 *     tags:
 *       - AI
 *     summary: AI4Chat (POST) - Tanya AI Ramah
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               text:
 *                 type: string
 *     responses:
 *       200:
 *         description: Respons berhasil
 */
router.post('/', async (req, res) => {
  await handleAi4Chat(req, res, req.body.text);
});

export default router;