import express from 'express';
const router = express.Router();

/**
 * @swagger
 * /search/contoh:
 *   get:
 *     tags:
 *       - Search
 *     summary: Pencarian Google Sederhana
 *     parameters:
 *       - in: query
 *         name: q
 *         required: true
 *         schema:
 *           type: string
 *     responses:
 *       200:
 *         description: Pencarian berhasil
 */
router.get('/', (req, res) => {
  const { q } = req.query;
  if (!q) return res.status(400).json({ status: false, error: "Parameter q wajib diisi" });
  res.json({ status: true, query: q, result: `Ini hanya contoh saja` });
});

export default router;