import express from 'express';
const router = express.Router();

/**
 * @swagger
 * /tools/search:
 *   get:
 *     tags: [Tools]
 *     summary: Pencarian Alat (Simulasi)
 *     parameters:
 *       - in: query
 *         name: q
 *         required: true
 *         schema:
 *           type: string
 *     responses:
 *       200:
 *         description: Berhasil
 */
router.get('/', (req, res) => {
  const { q } = req.query;
  if (!q) return res.status(400).json({ status: false, error: "Parameter q wajib diisi" });
  res.json({ status: true, query: q, result: `Simulasi hasil pencarian alat untuk: ${q}` });
});

export default router;