
# Blog Pribadi dengan Express.js & JSON ✨

Ini adalah proyek blog full-stack yang dibangun dari awal menggunakan Node.js dan Express.js. Blog ini tidak menggunakan database tradisional, melainkan menyimpan semua postingan dalam sebuah file JSON dan menulis konten menggunakan Markdown. Desainnya modern, mengusung tema **Glassmorphism** dengan mode gelap/terang dan preloader halaman yang elegan.

![Screenshot Blog](public/images/contoh-gambar.jpg)
*(Catatan: Ganti gambar di atas dengan screenshot proyek Anda yang sebenarnya! Anda bisa menaruh screenshot di folder `public/images` dan mengubah linknya.)*

---

## ✨ Fitur Utama

- **Desain Glassmorphism Modern:** Tampilan "kaca buram" yang elegan dan sedang tren.
- **Mode Gelap & Terang:** Tombol untuk mengubah tema dengan preferensi yang tersimpan di browser.
- **Sistem Postingan berbasis JSON & Markdown:** Konten dikelola dengan mudah tanpa perlu database.
- **Preloader Halaman Kustom:** Animasi loading yang menarik setiap kali halaman dimuat.
- **Tata Letak Grid Responsif:** Tampilan beradaptasi secara otomatis antara mobile (satu kolom) dan desktop (multi-kolom).
- **Sistem Tags per Postingan:** Setiap postingan dapat memiliki beberapa tag dengan ikon.
- **Tombol Berbagi Sosial:** Tombol untuk berbagi ke Twitter, Facebook, WhatsApp, dan menyalin link.
- **Pagination (Pembagian Halaman):** Postingan di halaman utama dibagi menjadi beberapa halaman jika sudah terlalu banyak.
- **Aman dari Serangan XSS:** Konten Markdown dibersihkan di server menggunakan DOMPurify sebelum ditampilkan.

---

## ⚙️ Instalasi & Menjalankan Proyek

Untuk menjalankan proyek ini di komputer lokal Anda, ikuti langkah-langkah berikut:

1.  **Clone repository ini:**
    ```bash
    git clone [https://github.com/NAMA_USER_ANDA/NAMA_REPO_ANDA.git](https://github.com/NAMA_USER_ANDA/NAMA_REPO_ANDA.git)
    ```

2.  **Masuk ke direktori proyek:**
    ```bash
    cd NAMA_REPO_ANDA
    ```

3.  **Instal semua dependensi yang dibutuhkan:**
    ```bash
    npm install
    ```

4.  **Jalankan server:**
    ```bash
    node app.js
    ```

5.  Buka browser dan kunjungi `http://localhost:3000`.

---

## ✍️ Cara Mengelola Konten

Semua konten blog dikelola melalui file `posts.json`.

### Menambah Postingan Baru

1.  Buka file `posts.json`.
2.  File ini berisi sebuah array `[...]`. Tambahkan objek JSON baru di dalam array tersebut untuk setiap postingan baru. Gunakan koma `,` untuk memisahkan setiap objek.
3.  Gunakan template di bawah ini untuk postingan baru Anda:

    ```json
    {
      "slug": "ini-adalah-judul-unik-untuk-url",
      "title": "Ini Adalah Judul Postingan Anda",
      "description": "Tulis deskripsi singkat (sekitar 155 karakter) untuk SEO di sini.",
      "author": "Nama Anda",
      "date": "TAHUN-BULAN-TANGGAL",
      "featuredImage": "/images/nama-gambar-unggulan.jpg",
      "imageAlt": "Deskripsi gambar unggulan untuk SEO",
      "content": "## Tulis Konten Anda di Sini dengan Format Markdown\n\nIni adalah paragraf baru. Anda bisa menulis **tebal**, *miring*, dan lainnya.",
      "tags": ["Tag Satu", "Tag Lain", "Teknologi"]
    }
    ```

**Penting:**
- `"slug"`: Harus unik untuk setiap postingan dan hanya berisi huruf kecil, angka, dan tanda hubung (`-`). Ini akan menjadi bagian dari URL.
- `"date"`: Gunakan format `YYYY-MM-DD`.
- `"content"`: Tulis semua isi postingan di sini menggunakan sintaks Markdown.

### Menambah Gambar

Ada dua cara untuk menambahkan gambar:

#### 1. Gambar Unggulan (Featured Image)

Ini adalah gambar utama yang muncul di bagian atas postingan dan sebagai pratinjau di halaman utama.

1.  Letakkan file gambar Anda di dalam folder `public/images/`.
2.  Di `posts.json`, isi properti `featuredImage` dengan path ke gambar tersebut, diawali dengan `/images/`. Contoh: `"/images/foto-liburan.png"`.
3.  Isi `imageAlt` dengan deskripsi singkat gambar untuk aksesibilitas dan SEO.

#### 2. Gambar di Dalam Isi Postingan

Untuk menampilkan gambar di tengah-tengah tulisan Anda:

1.  Pastikan gambar sudah ada di folder `public/images/`.
2.  Di dalam properti `"content"` pada `posts.json`, gunakan sintaks Markdown berikut di mana pun Anda ingin gambar itu muncul:

    ```markdown
    ![Deskripsi gambar untuk SEO dan aksesibilitas](/images/nama-gambar-anda.jpg)
    ```
Gambar ini akan otomatis menjadi responsif dan memiliki style yang bagus.

---

## 📄 Lisensi
Proyek ini dilisensikan di bawah Lisensi MIT.

