// Logika untuk Dark/Light Mode
document.addEventListener('DOMContentLoaded', () => {
    const themeSwitch = document.getElementById('theme-switch');
    if (themeSwitch) {
        const currentTheme = localStorage.getItem('theme');
        if (currentTheme) {
            document.body.classList.add(currentTheme);
            if(currentTheme === 'dark-mode') {
                themeSwitch.textContent = '☀️';
            } else {
                themeSwitch.textContent = '🌙';
            }
        }
        themeSwitch.addEventListener('click', () => {
            document.body.classList.toggle('dark-mode');
            let theme = 'light-mode';
            if (document.body.classList.contains('dark-mode')) {
                theme = 'dark-mode';
                themeSwitch.textContent = '☀️';
            } else {
                themeSwitch.textContent = '🌙';
            }
            localStorage.setItem('theme', theme);
        });
    }
});

// Logika untuk Preloader
window.addEventListener('load', () => {
    const preloader = document.getElementById('preloader');
    if (preloader) {
        preloader.classList.add('hidden');
    }
});
