document.addEventListener("DOMContentLoaded", () => {
  const loader = document.getElementById("loader");
  const loaderText = document.getElementById("loader-percentage");
  const card = document.querySelector(".profile-card");
  const buttons = document.querySelectorAll(".card-tabs button");
  const sections = document.querySelectorAll(".card-section");
  const timeline = document.getElementById("progressTimeline");
  const backgroundMusic = document.getElementById("backgroundMusic");
  const skillsList = document.getElementById("skillsList");
  let musicStarted = false;
  let skillsAnimated = false;

 
  const skillsData = [
    { name: "HTML", percent: 7 },
    { name: "CSS", percent: 7 },
    { name: "JavaScript", percent: 7 }
  ];

  const progressData = [
    { year: 2019, text: "Mulai belajar pemrograman." },
    { year: 2021, text: "Mengerjakan beberapa proyek kecil." },
    { year: 2023, text: "ini hanya contoh ajaa yaaaa 🗿 bisa kamu ganti sendiri" },
    { year: 2025, text: "Semangat belajarr 💪", current: true }
  ];

  
  [...progressData].reverse().forEach(item => {
    const div = document.createElement("div");
    div.classList.add("timeline-item");
    if (item.current) div.classList.add("current");
    div.innerHTML = `
      <div class="timeline-marker"></div>
      <div class="timeline-content">
        <div class="timeline-year">${item.year}</div>
        <div class="timeline-text">${item.text}</div>
      </div>
    `;
    timeline.appendChild(div);
  });

  
  function renderSkills() {
    skillsList.innerHTML = "";
    skillsData.forEach(({ name, percent }) => {
      const item = document.createElement("div");
      item.className = "skill";
      item.innerHTML = `
        <div class="skill-header">
          <span class="skill-name">${name}</span>
          <span class="skill-value">${percent}%</span>
        </div>
        <div class="skill-bar">
          <div class="skill-bar-fill" data-percent="${percent}"></div>
        </div>
      `;
      skillsList.appendChild(item);
    });
  }

  function animateSkills() {
    if (skillsAnimated) return;
    const fills = document.querySelectorAll(".skill-bar-fill");
    fills.forEach(el => {
      const p = el.getAttribute("data-percent");
      el.style.width = p + "%";
    });
    skillsAnimated = true;
  }

  renderSkills();

  
  let percent = 0;
  const loaderInterval = setInterval(() => {
    percent++;
    loaderText.textContent = percent + "%";
    if (percent >= 100) {
      clearInterval(loaderInterval);
      loader.style.display = "none";
      card.classList.remove("hidden");
    }
  }, 8);

  // Tab switching
  buttons.forEach(btn => {
    btn.addEventListener("click", () => {
      if (!musicStarted) {
        backgroundMusic.play().catch(e => console.log("Music failed:", e));
        musicStarted = true;
      }
      buttons.forEach(b => b.classList.remove("is-active"));
      sections.forEach(s => s.classList.remove("is-active"));
      btn.classList.add("is-active");
      const target = document.querySelector(btn.getAttribute("data-section"));
      target.classList.add("is-active");

      if (btn.getAttribute("data-section") === "#skills") {
        animateSkills();
      }
    });
  });

  // Volume music
  backgroundMusic.volume = 1.0;
});