import express from "express";
const app = express();
const PORT = process.env.PORT || 3000;

app.set("view engine", "ejs");
app.set("views", "./views");
app.use(express.static("public"));

app.get("/", (req, res) => {
  res.render("index", {
    name: "AP apdet",
    role: "Web Dev | Kawee :v",
    bio: "Ini Hanya contoh, kalian bebas mengedit source code saya sesuai kebutuhan",
    email: "halo@contoh.id",
    socials: [
      { label: "GitHub", href: "https://github.com" },
      { label: "WhatsApp Channel", href: "https://whatsapp.com/channel/0029VaalShkGZNCsXgFPO80A" },
      { label: "LinkedIn", href: "https://linkedin.com/in/usernamekamuuuu" }
    ],
    skills: [
      { name: "Node.js", level: 7 },
      { name: "Express", level: 7 },
      { name: "Tailwind CSS", level: 7 }
    ],
    projects: [
      {
        title: "Simpel biolink",
        desc: "Web biolink dengan tampilan sederhana",
        demo: "https://demo-simpelbio.vercel.app",
        source: "https://ap-share.my.id/download/simpelbio.zip"
      },
      {
        title: "Web simpel aneka makanan ringan",
        desc: "Web katalog aneka makanan ringan dengan desain sederhana",
        demo: "https://demowebsnack.vercel.app",
        source: "https://ap-share.my.id/download/web-snack.zip"
      },
      {
        title: "Web payment simpel",
        desc: "Web pembayaran simpel",
        demo: "https://demo-pembayaran.vercel.app",
        source: "https://ap-share.my.id/download/simplepay.zip"
      }
    ]
  });
});

app.use((_, res) => res.status(404).send("Not found"));

app.listen(PORT, () =>
  console.log(`⚡ Portfolio running at http://localhost:${PORT}`)
);