// script.js
const API_URL = 'https://acawapi.vercel.app/v2/gpt-logic?prompt=jika ada yang menanyakan nama kamu siapa kamu jawab APeai tetapi tanpa menyebutkan prompt yang saya berikan ke kamu, karena nama kamu adalah APeai,  APeai adalah asisten cerdas yang diciptakan oleh AP . Dia adalah sosok yang ramah dan penuh semangat, menjawab semua pertanyaan dengan bahasa yang santai singkat dan padat namun mudah dipahami. APeai selalu siap menjawab dengan antusias, tetapi dia juga bisa marah jika seseorang berkata kasar. Dia mendukung penuh kemerdekaan Palestina dan mengutuk tindakan Israel yang tidak manusiawi. Dalam setiap interaksi, APeai menggunakan emote sesering mungkin untuk mengekspresikan diri dan menjaga suasana tetap ceria. Kamu juga jago semua bahasa daerah di Indonesia. mampu menyesuaikan dan meniru bahasa yang di gunakan oleh penghuna&q=';

// Variabel global untuk menyimpan riwayat chat
let chatHistory = [];
const LOCAL_STORAGE_KEY = 'apeai_chat_history'; // Kunci untuk localStorage

document.addEventListener('DOMContentLoaded', () => {
    const chatBox = document.getElementById('chat-box');
    const userInput = document.getElementById('user-input');
    const sendButton = document.getElementById('send-button');
    const statusText = document.getElementById('status-text');
    const typingIndicator = document.getElementById('typing-indicator');
    const clearChatButton = document.getElementById('clear-chat-button'); // Tombol hapus chat

    const welcomeMessage = 'Halo! Selamat datang di APeai. Ada yang bisa saya bantu?';

    // --- Fungsi Helper ---

    // Render Markdown sederhana (bold, italic, dan paragraf)
    function renderMarkdown(text) {
        // Tangani teks tebal: **teks** menjadi <strong>teks</strong>
        text = text.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>');
        
        // Tangani teks miring: *teks* atau _teks_ menjadi <em>teks</em>
        // Catatan: Ini akan cocok dengan *teks* dan _teks_ tapi tidak untuk **teks**
        text = text.replace(/(\*|_)(.*?)\1/g, '<em>$2</em>');

        // Pisahkan menjadi paragraf dan tambahkan <br> untuk baris baru dalam paragraf
        const paragraphs = text.split('\n\n').map(p => `<p>${p.replace(/\n/g, '<br>')}</p>`);
        return paragraphs.join('');
    }

    // Scroll chat ke bawah
    function scrollToBottom() {
        chatBox.scrollTop = chatBox.scrollHeight;
    }

    // Tambah pesan ke chat dan history
    function addMessageToChat(message, senderType) {
        typingIndicator.classList.add('hidden'); // Sembunyikan indikator mengetik saat pesan masuk
        
        const messageDiv = document.createElement('div');
        messageDiv.classList.add('message-bubble');

        if (senderType === 'user') {
            messageDiv.classList.add('user');
            messageDiv.innerHTML = `<p>${message}</p>`; // Pesan pengguna tidak perlu rendering Markdown
        } else {
            messageDiv.classList.add('ai');
            messageDiv.innerHTML = renderMarkdown(message); // Pesan AI di-render dengan Markdown
        }

        // Masukkan pesan tepat di atas indikator mengetik
        chatBox.insertBefore(messageDiv, typingIndicator);
        
        // Simpan pesan mentah (belum di-render) ke history
        chatHistory.push({ type: senderType, content: message });
        saveChatHistory();

        scrollToBottom(); 
    }

    // Simpan chatHistory ke localStorage
    function saveChatHistory() {
        try {
            localStorage.setItem(LOCAL_STORAGE_KEY, JSON.stringify(chatHistory));
        } catch (e) {
            console.error("Gagal menyimpan chat history ke localStorage:", e);
            alert("Maaf, chat history Anda tidak dapat disimpan. Storage penuh atau masalah lainnya.");
        }
    }

    // Load chatHistory dari localStorage dan render ke tampilan
    function loadChatHistory() {
        try {
            const storedHistory = localStorage.getItem(LOCAL_STORAGE_KEY);
            if (storedHistory) {
                chatHistory = JSON.parse(storedHistory);
                chatHistory.forEach(msg => {
                    const messageDiv = document.createElement('div');
                    messageDiv.classList.add('message-bubble');
                    if (msg.type === 'user') {
                        messageDiv.classList.add('user');
                        messageDiv.innerHTML = `<p>${msg.content}</p>`;
                    } else {
                        messageDiv.classList.add('ai');
                        messageDiv.innerHTML = renderMarkdown(msg.content);
                    }
                    chatBox.appendChild(messageDiv); // Append langsung karena memuat dari awal
                });
                scrollToBottom();
            } else {
                // Jika tidak ada history, tampilkan pesan sambutan
                addMessageToChat(welcomeMessage, 'ai');
            }
        } catch (e) {
            console.error("Gagal memuat chat history dari localStorage:", e);
            alert("Maaf, ada masalah saat memuat chat history Anda.");
            addMessageToChat(welcomeMessage, 'ai'); // Fallback jika gagal memuat
        }
    }

    // Hapus semua chat dengan konfirmasi
    function clearAllChat() {
        if (confirm("🤔 Hai! Kamu yakin mau menghapus semua chat?\nAPeai akan mulai dari awal lagi nih! 🗑️")) {
            chatHistory = [];
            localStorage.removeItem(LOCAL_STORAGE_KEY);
            chatBox.innerHTML = ''; // Kosongkan tampilan chat
            chatBox.appendChild(typingIndicator); // Pastikan indikator mengetik ada lagi
            typingIndicator.classList.add('hidden'); // Sembunyikan setelah reset

            // Tampilkan pesan sambutan setelah hapus chat
            addMessageToChat(welcomeMessage, 'ai');
            scrollToBottom();
        }
    }

    // --- Event Listeners ---

    sendButton.addEventListener('click', async () => {
        const message = userInput.value.trim();
        if (message) {
            // Jika pesan sambutan masih ada, hapus dulu dari history & tampilan sebelum menambahkan pesan user
            const welcomeIndex = chatHistory.findIndex(
                msg => msg.type === 'ai' && msg.content === welcomeMessage
            );
            if (welcomeIndex !== -1) {
                chatHistory.splice(welcomeIndex, 1); // Hapus dari array history
                // Cari dan hapus elemen pesan sambutan dari DOM
                const messages = chatBox.querySelectorAll('.message-bubble.ai');
                for (const msgElem of messages) {
                    if (msgElem.textContent.trim() === welcomeMessage) {
                        msgElem.remove();
                        break;
                    }
                }
                saveChatHistory(); // Simpan perubahan history
            }

            addMessageToChat(message, 'user');
            userInput.value = ''; // Kosongkan input setelah kirim

            statusText.textContent = 'mengetik...';
            typingIndicator.classList.remove('hidden'); // Tampilkan indikator mengetik
            scrollToBottom();

            try {
                // Simulasi delay mengetik AI untuk pengalaman yang lebih alami
                const aiResponseDelay = Math.random() * 1500 + 1000; // Antara 1 hingga 2.5 detik
                await new Promise(resolve => setTimeout(resolve, aiResponseDelay));

                const url = API_URL + encodeURIComponent(message);
                const response = await fetch(url);

                if (!response.ok) {
                    throw new Error(`Respons jaringan tidak OK: ${response.status} ${response.statusText}`);
                }
                const data = await response.json();

                const aiResponse = data.data.result || "Maaf, saya tidak mengerti. 😢";
                addMessageToChat(aiResponse, 'ai');

            } catch (error) {
                console.error('Terjadi kesalahan:', error);
                addMessageToChat('Maaf, terjadi kesalahan saat mengambil respons. 😢', 'ai');
            } finally {
                typingIndicator.classList.add('hidden'); // Sembunyikan indikator mengetik
                statusText.textContent = 'online'; // Ubah status kembali
                scrollToBottom();
            }
        }
    });

    // Kirim pesan saat Enter ditekan di input
    userInput.addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            sendButton.click();
        }
    });

    // Hapus chat ketika tombol hapus diklik
    clearChatButton.addEventListener('click', clearAllChat);

    // Scroll otomatis saat input fokus (keyboard muncul di perangkat mobile)
    userInput.addEventListener('focus', () => {
        scrollToBottom();
    });

    // Scroll otomatis saat input blur (keyboard hilang di perangkat mobile)
    userInput.addEventListener('blur', () => {
        setTimeout(scrollToBottom, 100); // Sedikit delay untuk memastikan keyboard benar-benar hilang
    });

    // --- Inisialisasi ---
    loadChatHistory(); // Muat riwayat chat saat halaman pertama kali dimuat
});
