# 🌶️ Snack Pedas Mantap Website

Ini adalah website e-commerce sederhana untuk **Snack Pedas Mantap**, dibangun dengan **Node.js**, **Express.js**, dan template engine **EJS**. Website ini menampilkan katalog produk, informasi toko, dan memungkinkan pelanggan memesan langsung via WhatsApp.

---

## 🚀 Fitur Utama

✅ Halaman Beranda: menampilkan produk unggulan & promo reseller  
✅ Katalog Produk: daftar lengkap produk dengan harga & berat  
✅ Halaman Tentang Kami: informasi detail toko & alamat  
✅ Integrasi WhatsApp: tombol langsung untuk pemesanan & pertanyaan  
✅ Desain Responsif: mendukung berbagai ukuran layar  
✅ Data Produk Berbasis JSON: mudah dikelola tanpa database kompleks  
✅ Navigasi antar halaman: Beranda, Katalog, Tentang Kami, Kontak  
✅ Label produk: terlaris, baru, promo  
✅ Alamat terhubung ke Google Maps  
✅ Bagian promosi reseller

---

## 🛠️ Persyaratan Sistem

- Node.js (Versi 14 atau lebih baru direkomendasikan)
- npm (terinstal bersama Node.js)

---

## 📦 Cara Menjalankan Proyek

Clone repository Anda:
```bash
git clone https://github.com/nama-pengguna-github-anda/nama-repo-anda.git
cd nama-repo-anda

Instal dependensi:

npm install express ejs

Jalankan server:

node app.js

Server akan berjalan di http://localhost:3000.


---

📂 Struktur Folder Proyek

nama-proyek-makanan-ringan/
├── public/
│   ├── css/
│   │   └── style.css
│   ├── js/
│   │   └── script.js
│   └── images/
│       ├── background-pedas.jpg
│       └── produk/
├── views/
│   ├── partials/
│   │   ├── header.ejs
│   │   └── footer.ejs
│   ├── index.ejs
│   ├── katalog.ejs
│   └── tentang.ejs
├── data/
│   └── produk.json
├── app.js
├── package.json
└── README.md


---

📦 Cara Mengelola Produk

➕ Menambah Produk Baru

1. Buka file data/produk.json.


2. Tambahkan objek JSON baru ke array produk, misalnya:



{
  "id": "nama-produk-baru-anda",
  "nama": "Nama Produk Baru Anda",
  "deskripsi": "Deskripsi singkat produk.",
  "harga": 15000,
  "gambar": "/images/produk/nama-gambar-produk.jpg",
  "isFeatured": false,
  "isBestSeller": false,
  "isNew": true,
  "isPromo": false
}

3. Tambahkan gambar produk ke folder public/images/produk/.


4. Restart server:



Ctrl + C lalu node app.js


---

✏️ Mengedit Produk

Edit file data/produk.json.

Ubah objek produk sesuai kebutuhan.

Restart server untuk melihat perubahan.



---

🗑️ Menghapus Produk

Hapus objek produk dari data/produk.json.

Restart server.



---

🖼️ Cara Menambah Foto Produk

Siapkan gambar produk dengan format .jpg, .png, atau .webp.

Simpan gambar ke folder:


public/images/produk/

Pastikan properti "gambar" di produk.json sesuai dengan nama file gambar.



---

⚙️ Penyesuaian Lanjutan

Informasi Toko: ubah namaToko, deskripsiToko, alamatToko, dan nomorWa di app.js.

Link Sosial/Marketplace: update URL di:

views/partials/footer.ejs

views/index.ejs (bagian .social-promo dan .reseller-promo)


Gaya: ubah public/css/style.css.

Hero Background: ganti public/images/background-pedas.jpg dengan gambar latar baru.