const express = require('express');
const path = require('path');
const app = express();
const PORT = process.env.PORT || 3000;

// Set view engine to EJS
app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));

// Serve static files from the 'public' directory
app.use(express.static(path.join(__dirname, 'public')));

// Load product data
const produk = require('./data/produk.json');

// Route for Home page
app.get('/', (req, res) => {
    res.render('index', {
        title: 'Selamat Datang di APsnack!'
    });
});

// Route for Katalog page
app.get('/katalog', (req, res) => {
    res.render('katalog', {
        title: 'Katalog Produk Kami',
        produk: produk // Pass all products to the catalog page
    });
});

// Route for About Us page
app.get('/tentang', (req, res) => {
    res.render('tentang', {
        title: 'Tentang Kami',
        namaToko: 'APsnack',
        deskripsiToko: 'Kami adalah produsen makanan ringan pedas yang berkomitmen menyajikan cita rasa autentik dan kualitas terbaik. Setiap produk kami dibuat dengan bahan pilihan dan bumbu rempah rahasia yang akan membuat lidah Anda ketagihan. Berdiri sejak 2020, kami terus berinovasi untuk menghadirkan varian snack pedas yang beragam dan sesuai selera para pecinta pedas di seluruh Indonesia. Kami percaya, kebahagiaan sejati ada dalam setiap gigitan pedas yang nikmat!',
        alamatToko: 'Jl. epenjetsevenfold No. 123, Kecamatan AP, Kota AP, Jawa, 601 (Hanya contoh)', // Ganti dengan alamat Anda di Surabaya
        nomorWa: '628123' // Nomor WA Anda
    });
});

// Start the server
app.listen(PORT, () => {
    console.log(`Server berjalan di http://localhost:${PORT}`);
});