# 🚀 Website Informasi Kelas (Node.js & EJS)

Selamat datang di repositori Website Informasi Kelas! Ini adalah aplikasi web sederhana yang dibangun menggunakan Node.js dan Express, dirancang untuk menjadi pusat informasi digital bagi sebuah kelas.

Aplikasi ini menampilkan informasi penting seperti struktur organisasi kelas, rincian keuangan kas yang transparan, galeri foto, hingga pengumuman penting, semuanya dalam satu dasbor yang menarik dan mudah diakses.

*[Letakkan gambar screenshot tampilan website Anda di sini jika ada]*

---

## ✨ Fitur Utama

-   **Login Sederhana**: Siapa saja bisa masuk hanya dengan memasukkan nama untuk melihat informasi kelas.
-   **Dashboard Informatif**: Menampilkan semua informasi penting dalam satu halaman.
-   **Info & Struktur Kelas**: Rincian Wali Kelas, jumlah siswa, dan jajaran pengurus kelas dengan ikon yang menarik.
-   **Keuangan Kas Transparan**: Tabel rincian setiap transaksi kas (pemasukan dan pengeluaran).
-   **Galeri Slideshow**: Galeri foto kenangan kelas yang dinamis, bisa bergeser otomatis maupun manual.
-   **Toast Pengumuman**: Bar pengumuman bergerak di bagian atas untuk menyampaikan informasi penting.
-   **Desain Menarik**: Tampilan modern dan bersih yang dibuat dengan CSS kustom.

---

## 💻 Teknologi yang Digunakan

-   **Backend**: Node.js, Express.js
-   **Frontend**: EJS (Embedded JavaScript Templates) untuk rendering HTML.
-   **Session Management**: `express-session` untuk menangani login.
-   **Slideshow Library**: Swiper.js
-   **Styling**: HTML5 & CSS3
-   **Icons**: Font Awesome

---

## ⚙️ Cara Instalasi dan Menjalankan

Untuk menjalankan proyek ini di komputer lokal Anda, ikuti langkah-langkah berikut:

1.  **Clone repositori ini** (atau unduh ZIP dan ekstrak).
    ```bash
    git clone [URL_REPOSITORI_ANDA]
    ```
2.  **Masuk ke direktori proyek**.
    ```bash
    cd [NAMA_FOLDER_PROYEK]
    ```
3.  **Instal semua dependensi** yang dibutuhkan melalui npm.
    ```bash
    npm install
    ```
4.  **Jalankan server**.
    ```bash
    npm start
    ```
    Atau bisa juga dengan:
    ```bash
    node server.js
    ```
5.  **Buka browser** Anda dan kunjungi alamat `http://localhost:3000`.

---

## 🔧 Cara Kustomisasi Data

Semua data utama website ini (seperti info kelas, daftar foto, dan keuangan) diatur secara terpusat di dalam file `server.js`. Buka file tersebut dan temukan objek `const dataKelas = { ... };`.

### 📂 Mengedit Info & Struktur Kelas

Untuk mengubah nama wali kelas, jumlah siswa, atau pengurus kelas, cukup edit nilai-nilai properti di bawah ini di dalam `dataKelas`.

```javascript
// Contoh di dalam server.js
const dataKelas = {
  namaKelas: "XI RPL 2", // Ganti nama kelas
  waliKelas: "Ibu Siska Amelia, S.Pd", // Ganti nama wali kelas
  jumlahSiswaLaki: 15,
  jumlahSiswaPerempuan: 21,
  strukturKelas: {
    ketua: "Budi", // Ganti nama ketua
    wakil: "Santi",
    sekretaris: "Eko",
    bendahara: "Wati"
  },
  // ... data lainnya
};
```

### 💰 Menambah/Mengedit Keuangan Kelas

Semua transaksi dicatat dalam array `transaksiKas`. Untuk menambah transaksi baru, cukup tambahkan objek baru ke dalam array ini.

-   `tipe: 'masuk'` untuk pemasukan.
-   `tipe: 'keluar'` untuk pengeluaran.

```javascript
// Contoh di dalam server.js
transaksiKas: [
  // ... (transaksi yang sudah ada)
  // Menambah transaksi baru:
  { tanggal: "2025-06-10", deskripsi: "Beli tinta printer untuk kelas", tipe: "keluar", jumlah: 55000 },
  { tanggal: "2025-06-11", deskripsi: "Iuran kas susulan dari 1 siswa", tipe: "masuk", jumlah: 5000 }
]
```

### 🖼️ Menambah Foto di Galeri

Menambah foto ke galeri slideshow adalah proses dua langkah:

1.  **Letakkan File Foto**: Salin file gambar baru Anda (misal: `kenangan_baru.jpg`) ke dalam folder `public/images/`.

2.  **Tambahkan Data di `server.js`**: Tambahkan objek baru ke dalam array `galeriFoto`. Pastikan properti `file` sesuai dengan nama file gambar yang baru Anda letakkan.

```javascript
// Contoh di dalam server.js
galeriFoto: [
  // ... (data foto yang sudah ada)
  // Menambah data foto baru:
  {
    file: 'kenangan_baru.jpg', // Nama file harus sama persis
    deskripsi: 'Suasana saat lomba 17 Agustus'
  }
]
```

---

Dibuat dengan ❤️ oleh AP
