webreq - Sistem Formulir Pengajuan Permintaan Otomatis

 ⬅️ Ganti ini dengan URL Vercel Anda

Sebuah aplikasi web sederhana namun efektif untuk mengumpulkan berbagai jenis permintaan (permintaan pembuatan situs web, permintaan fitur bot, dan umpan balik umum) dan secara otomatis mengirimkan notifikasi terstruktur ke bot Telegram.

🌟 Fitur Utama
Formulir Pengajuan Terpisah: Menyediakan antarmuka yang berbeda untuk:

Permintaan Pembuatan Website: Mengumpulkan detail proyek website yang dibutuhkan.

Permintaan Fitur Bot: Fokus pada penambahan fitur baru ke bot yang sudah ada, dengan opsi pemilihan tipe plugin (ESM/CJS) atau berbasis case penggunaan.

Kritik & Saran: Saluran mudah untuk umpan balik umum.

Notifikasi Telegram Otomatis: Setiap pengajuan formulir akan segera dikirim sebagai pesan terstruktur dan rapi ke chat Telegram yang ditentukan, lengkap dengan informasi pengirim, waktu, dan detail permintaan.

Waktu Lokal: Stempel waktu pada setiap notifikasi disesuaikan dengan zona waktu Jakarta (WIB/Waktu Indonesia Barat).

Desain Responsif: Antarmuka formulir yang bersih dan dapat diakses di berbagai perangkat.

🛠️ Teknologi yang Digunakan
Backend:

Node.js: Lingkungan runtime JavaScript.

Express.js: Framework web untuk Node.js.

Axios: HTTP client berbasis Promise untuk melakukan permintaan ke API Telegram.

dotenv: Untuk mengelola variabel lingkungan (.env).

Frontend:

EJS (Embedded JavaScript): Templating engine untuk menghasilkan HTML dinamis.

HTML, CSS.

Deployment:

Vercel: Platform cloud untuk deployment aplikasi web yang cepat dan mudah.

⚙️ Persyaratan Sistem
Node.js (versi 14 atau lebih tinggi direkomendasikan)

npm atau Yarn

🚀 Instalasi & Menjalankan Secara Lokal
Untuk menjalankan proyek ini di mesin lokal Anda:

Clone Repositori:

Bash

git clone https://github.com/YourGitHubUsername/webreq.git # Ganti dengan URL repo Anda
cd webreq
Instal Dependensi:

Bash

npm install
# atau jika Anda menggunakan Yarn
# yarn install
Konfigurasi Variabel Lingkungan:
Buat file .env di root proyek Anda dan tambahkan detail bot Telegram Anda:

TELEGRAM_BOT_TOKEN=YOUR_TELEGRAM_BOT_TOKEN
TELEGRAM_CHAT_ID=YOUR_TELEGRAM_CHAT_ID
Ganti YOUR_TELEGRAM_BOT_TOKEN dengan token bot Anda yang didapat dari BotFather.

Ganti YOUR_TELEGRAM_CHAT_ID dengan ID chat atau ID grup tempat Anda ingin menerima notifikasi.

Jalankan Aplikasi:

Untuk pengembangan (dengan hot-reloading):

Bash

npm run dev
Untuk produksi:

Bash

npm start
Akses Aplikasi:
Buka browser Anda dan kunjungi http://localhost:3000.

☁️ Deployment ke Vercel
Proyek ini sangat cocok untuk di-deploy menggunakan Vercel.

Siapkan Repositori Git: Pastikan kode Anda sudah di-push ke GitHub/GitLab/Bitbucket.

Buat Akun Vercel: Jika belum punya, daftar di vercel.com.

Import Proyek: Dari dashboard Vercel, pilih "New Project" dan import repositori webreq Anda.

Konfigurasi Environment Variables:

Ini adalah langkah paling penting. Vercel tidak membaca file .env lokal Anda.

Di pengaturan proyek Vercel (saat mengimport atau setelahnya di bagian "Settings" -> "Environment Variables"), tambahkan:

TELEGRAM_BOT_TOKEN dengan nilai token bot Anda.

TELEGRAM_CHAT_ID dengan nilai ID chat Telegram Anda.

Deploy: Ikuti instruksi di Vercel untuk menyelesaikan deployment. Vercel akan secara otomatis mendeteksi konfigurasi Node.js dan menjalankan npm start.

Setelah deployment berhasil, aplikasi Anda akan tersedia di URL Vercel yang unik (misalnya, https://your-project-name.vercel.app).

🤝 Kontribusi
Jika Anda memiliki saran atau ingin berkontribusi pada proyek ini, silakan buka issue atau kirimkan pull request.

📄 Lisensi
Proyek ini dilisensikan di bawah lisensi ISC. Lihat file LICENSE untuk detail lebih lanjut.

📧 Kontak
Jika ada pertanyaan, jangan ragu untuk menghubungi.

[AP]