const express = require('express');
const fs = require('fs');
const path = require('path');
const app = express();
const port = 3000;

app.set('view engine', 'ejs');
app.use(express.static('public'));

const categoriesPath = path.join(__dirname, 'categories.json');
const categories = JSON.parse(fs.readFileSync(categoriesPath, 'utf-8'));


app.get('/', (req, res) => {
  res.render('index', { categories: categories });
});

app.get('/kategori/:slug', (req, res) => {
  const categorySlug = req.params.slug;
  const selectedCategory = categories.find(cat => cat.slug === categorySlug);

  if (selectedCategory) {
    res.render('category', { category: selectedCategory });
  } else {
    res.status(404).send('Kategori tidak ditemukan');
  }
});

app.listen(port, () => {
  console.log(`Server berjalan di http://localhost:${port}`);
});